import numpy as np
import pandas as pd
import os
from gen_gaussian_noise import gen_gaussian_noise,check_snr

#--------------------------------------------

np.set_printoptions(suppress=True)  # Decimal representation instead of exponent, for saving memory

os.getcwd()
os.chdir(r'D:\study\Marco\Politecnico di Torino\Marano Giuseppe Carlo - Lavoro indici di danno MLP\Database') # change path to raw datas
o = os.listdir()
o.sort(key=lambda x : int(x.split("_")[2]))   # Sort by seeds
# print(o)  # View arrangement
# len(o)    # View quantity  8242 in  our situation

#--------------------------------------------  raw datas to noisy datas
n = 1  #number of the data (1-8242)
SNR = 20.0 # 40.0 60.0
for path in o:
    name = path[:-4].split("_")  # ['OutputAccelMatrixDAMAGED','seed','4162','damage','0.0']
    seed = int(name[2])

    data = np.loadtxt(path) #'OutputAccelMatrixDAMAGED_seed_4162_damage_0.0.txt'
    data = data.T  # 7*150002
    data = data[1:6, 1:]  # 5*150001
    # print(data)
    # print("*"* 40)
    signal1 = []
    for i in range(0, 5):
        signal = data[i, :]
        noise = gen_gaussian_noise(signal, 20.0, seed)
        # print(signal)
        noisy_signal = signal + noise
        signal1.append(noisy_signal)
    # print("-"* 40)
    # print(signal1)
    n += 1
    np.savetxt(f'D:/DESKTOP/Jupternotebook/Thesis/Database/20/20.0dB_seed_{seed}_Damage_{name[4]}.txt', signal1, fmt='%f')

    if n % 100 == 0: # check snr every 100 datas
        SNR = check_snr(signal, noise)
        print(n, SNR)

    if n == 8243:
        print("ok")  # ok when finish and all the datas are added the white noise

#np.shape(signal1)  (5,150001)

#——————————————————————————————————————————————————————




